% This function was extracted from the following code:
% MATLAB code for implementation of iterative adaptive image deblurring
% algorithm:
% A. Kheradmand and P. Milanfar, A general framework for regularized, similarity-based image restoration, 
% IEEE Transactions on Image Processing, vol. 23, no. 12, pp. 51365151, Dec 2014.
% This is experimental software. It is provided for non-commercial research purposes only. Use at your own risk. No warranty is implied by 
% this distribution. Copyright  2014 by University of California.

function SqInteg = IntegralImage(v,xShift,yShift)

t = ImShift(v,xShift,yShift);
% Sqaured difference image
SqDiff = (v-t).^2;
% Cumulative sum  along rows
SqInteg = cumsum(SqDiff,1);
% Cumulative sum along columns
SqInteg = cumsum(SqInteg,2);
end