%% read image and make it small for a cheaper computation
% >> current version takes about 10.5 seconds on my computer
img = rgb2gray(im2double(imread('pilz.jpg')));
imgsmall = imresize(img, 0.3);

%% construct similarity matrix
W = Integral_NLM(imgsmall,1,7, .1);
d = 1./sqrt(full(sum(W,2)));
D = spdiags(d, 0, size(W,1), size(W,2));
W = D*W*D;

%% compute second largest eigenvector
% TODO: Replace the line below by your own code!
[V,D] = eigs(W,2,'lm');


%% resize to original size and display result
map = imresize(reshape(V(:,2), size(imgsmall)), size(img));
figure, imagesc(map), colorbar, title('Visualization of a second largest eigenvector'),
figure, imshow(img), hold on, contour(map, [-0.005,-0.005], 'r-', 'linewidth',4),title('Spectral clustering result'),
