img = im2double(imread('peppers.png'));
figure, imshow(img)
[ny,nx,nc] = size(img);
% predefined dictionary of colors. Goal: Find a sparse linear combination
% of these colors to represent every color in the given image. 
colorDictionary = [
    1         1         0.2;
    1         0.5       0.3;
    1         0.75       0;
    0.27      0.15       0.27;
    1         1          1]';
colorDictionary = colorDictionary./repmat(sqrt(sum(colorDictionary.^2,1)),[nc,1]);
data = reshape(img, [nx*ny,nc])';

%% min_{u} ||colorDictionary*u-data||^2 + alph \|u\|_1
u = zeros(size(colorDictionary,2), nx*ny);

% your code goes here

%% illustrate results 
for j=1:size(colorDictionary,2)
    figure, imagesc(reshape(u(j,:), [ny,nx])), colorbar;
    title(['Abundance map for color ', num2str(j)]);
end
figure, imshow(reshape((colorDictionary*u)', [ny,nx,nc]))
